# HerNest Financial Templates
## Google Sheets Guide

### 🎉 Welcome!

You have 9 financial templates ready for Google Sheets!

---

## 📤 How to Upload to Google Sheets

### Option 1: Upload Files

1. Go to [drive.google.com](https://drive.google.com)
2. Click **New** → **File upload**
3. Select all 9 HerNest templates
4. Wait for upload to complete
5. Double-click any file to open in Google Sheets

### Option 2: Drag and Drop

1. Open Google Drive in your browser
2. Drag all 9 template files from your computer
3. Drop them into Google Drive
4. They'll automatically upload

---

## 📊 What You Have

**9 Templates:**
1. HerNest_Income_Template
2. HerNest_Expenses_Template
3. HerNest_Budget_Tracker_Template
4. HerNest_Cash_Flow_Template
5. HerNest_Cashbook_Template
6. HerNest_Profit_Loss_Statement_Template
7. HerNest_Profit_Loss_Summary_Template
8. HerNest_Assets_Liabilities_Template
9. HerNest_General_Ledger_Template

**Each has 2 sheets:**
- **Instructions** - How to use
- **Data Entry** - Your workspace

---

## 🚀 Quick Start

### Step 1: Upload (5 minutes)
Upload all templates to Google Drive

### Step 2: Start with 3 (10 minutes)
Open these first:
- Income Tracker
- Expenses Tracker
- Cash Flow Statement

### Step 3: Read & Use
- Click the **Instructions** tab first
- Then go to **Data Entry** tab
- Start entering your data!

---

## 💡 Using in Google Sheets

### Making a Copy (Recommended)
1. Open template in Google Sheets
2. Click **File** → **Make a copy**
3. Rename: "Income_January2025_MyBusiness"
4. Work in the copy, keep original blank

### Sharing with Your Team
1. Click **Share** button (top right)
2. Add team members' emails
3. Set permissions (View/Comment/Edit)
4. Click **Send**

### Access on Phone
1. Install **Google Sheets app** (free)
2. Sign in with your Google account
3. All your templates appear automatically
4. Edit on the go!

### Auto-Save
✓ Google Sheets saves automatically  
✓ No need to click save  
✓ See "All changes saved" in top bar

---

## 📱 Mobile Tips

**On Your Phone:**
- Tap template to open
- Swipe between sheets (Instructions/Data Entry)
- Tap cell to edit
- Use number keyboard for amounts
- Auto-saves as you type

**Best Practices:**
- Use landscape mode for better view
- Zoom in/out with pinch gesture
- Use voice typing for notes

---

## 🎨 Brand Colors

Your templates feature HerNest branding:
- **Deep Teal headers** - Main brand color
- **Coral column headers** - Accent color
- **Alternating rows** - Easy reading
- **Professional fonts** - Clean look

---

## 💪 Success Tips

✅ **Upload all 9** - Have them ready  
✅ **Start with 3** - Don't overwhelm yourself  
✅ **Make copies** - Keep originals blank  
✅ **Update weekly** - Build the habit  
✅ **Use on phone** - Update anywhere

---

## 🆘 Troubleshooting

**"File won't open"**
→ Make sure you're signed into Google account

**"Can't edit"**
→ Make a copy (File → Make a copy)

**"Lost my data"**
→ Check version history (File → Version history)

**"Formulas not working"**
→ Google Sheets uses same formulas as Excel

**"Need more rows"**
→ Right-click row number → Insert rows

---

## 📊 Adding Formulas

Google Sheets formulas work automatically!

**Common formulas:**
- Total: `=SUM(C5:C50)`
- Average: `=AVERAGE(C5:C50)`
- Count: `=COUNT(C5:C50)`
- If/Then: `=IF(C5>1000,"High","Low")`

Type `=` to start any formula.

---

## 🔐 Privacy & Security

**Your data is safe:**
✓ Stored in your Google Drive  
✓ Only you can access (unless you share)  
✓ Encrypted by Google  
✓ Backed up automatically

**Tips:**
- Don't share templates with strangers
- Use strong Google account password
- Enable 2-factor authentication

---

## 📞 Need Help?

**HerNest Support:**
Email: [Your Email]  
Website: [Your Website]  
Phone: [Your Phone]

**Google Sheets Help:**
- Click **Help** menu in Google Sheets
- Visit [support.google.com/sheets](https://support.google.com/sheets)

---

## 🌟 Next Steps

**Today:**
1. ✅ Upload templates to Google Drive
2. ✅ Open Income Tracker
3. ✅ Read Instructions sheet
4. ✅ Enter your first income

**This Week:**
1. ✅ Use all 3 starter templates
2. ✅ Enter last month's data
3. ✅ Calculate your profit/loss
4. ✅ Make copies for next month

**This Month:**
1. ✅ Build weekly update habit
2. ✅ Add more templates as needed
3. ✅ Review your numbers
4. ✅ Make data-driven decisions

---

**You've got this!**

Every entry builds your financial clarity.  
Every review strengthens your business.  
Every data-driven decision empowers your future.

---

**HerNest**  
*Human Centered Data Ecosystem*

Empathy First • Truth as Foundation • Sustainable Impact

© 2025 HerNest
